// Weapon Remover
// by: Marky_UK
//
// Required Modules:
// amxmodx
// amxmisc
// engine
//
// Instructions:
// Create a folder called "WeaponRemover" at "addons/amxmodx/configs"
// Inside the folder, create a text file "<mapname>.txt"
// Inside the "<mapname>.txt" file, add the list of weapons you want removing
//
// Example:
// To block AWP's and scouts on the map, fy_snow
// Create a text file, "fy_snow.txt" in "addons/amxmodx/configs/WeaponRemover"
// Inside "fy_snow.txt" type:
//                            awp
//                            scout

#include <amxmodx>
#include <amxmisc>
#include <engine>

#define PLUGIN "Weapon Remover"
#define AUTHOR "Marky_UK"
#define VERSION "1.00"

public plugin_init()
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
    new filepath[256]
    new mapfile[256]
    new mapname[256]
    get_mapname(mapname, sizeof(mapname) -1)
    get_configsdir(filepath, sizeof(filepath) -1)
    format(filepath, 255, "%s/WeaponRemover", filepath)
    format(mapfile, 255, "%s/%s.txt", filepath, mapname)
    new filepointer = fopen(mapfile,"r")
    if(filepointer == 0)
    {
        return PLUGIN_HANDLED;
    }

    new mapfiledata[681],weapon[13]
    while(fgets(filepointer,mapfiledata,sizeof(mapfiledata) -1))
    {
        trim(mapfiledata)
        parse(mapfiledata,weapon,12)
        new WeaponModel[26]
        format(WeaponModel,sizeof(weapon) + 13,"models/w_%s.mdl",weapon)

        new WepID = -1
        while((WepID = find_ent_by_model(WepID,"armoury_entity",WeaponModel)) != 0)
        {
            remove_entity(WepID)
        }
    }
    fclose(filepointer)
    return PLUGIN_HANDLED
}

/*
*	  GM-Serv.Ru
*	 , , , , , ...
*	: , ,  
*/